/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2338;
import net.minecraft.class_2381;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4635;
import net.minecraft.class_5821;
import twilightforest.world.components.feature.trees.TFGenCanopyMushroom;

@ParametersAreNonnullByDefault
public class TFGenCanopyMushroomRed
extends TFGenCanopyMushroom {
    private int altHeads = 0;

    public TFGenCanopyMushroomRed(Codec<class_4635> featureConfigurationCodec) {
        super(featureConfigurationCodec);
    }

    @Override
    public boolean method_13151(class_5821<class_4635> context) {
        this.altHeads = context.method_33654().nextInt(100) + 1;
        return super.method_13151(context);
    }

    @Override
    protected int method_23377(Random random) {
        return super.method_23377(random) + 3;
    }

    @Override
    protected int getBranches(Random random) {
        return 3;
    }

    @Override
    protected double getLength(Random random) {
        return 10 + random.nextInt(2);
    }

    @Override
    protected void method_23375(class_1936 levelAccessor, Random random, class_2338 pos, int height, class_2338.class_2339 mutableBlockPos, class_4635 featureConfiguration) {
        if (this.altHeads <= 33) {
            this.makeVanillaCap(levelAccessor, random, pos, height, mutableBlockPos, featureConfiguration);
        } else if (this.altHeads <= 66) {
            this.makeSmoothCap(levelAccessor, random, pos, height, mutableBlockPos, featureConfiguration);
        } else if (this.altHeads <= 99) {
            this.makeSpheroidCap(levelAccessor, random, pos, height, mutableBlockPos, featureConfiguration);
        } else {
            super.method_23375(levelAccessor, random, pos, height, mutableBlockPos, featureConfiguration);
        }
    }

    protected void makeVanillaCap(class_1936 levelAccessor, Random random, class_2338 pos, int height, class_2338.class_2339 mutableBlockPos, class_4635 featureConfiguration) {
        for (int y = height - 3; y <= height; ++y) {
            int j = y < height ? featureConfiguration.field_21232 : featureConfiguration.field_21232 - 1;
            int k = featureConfiguration.field_21232 - 2;
            for (int x = -j; x <= j; ++x) {
                for (int z = -j; z <= j; ++z) {
                    boolean zMinMax;
                    boolean xIsMin = x == -j;
                    boolean xIsMax = x == j;
                    boolean zIsMin = z == -j;
                    boolean zIsMax = z == j;
                    boolean xMinMax = xIsMin || xIsMax;
                    boolean bl = zMinMax = zIsMin || zIsMax;
                    if (y < height && xMinMax == zMinMax) continue;
                    mutableBlockPos.method_25504((class_2382)pos, x, y, z);
                    if (levelAccessor.method_8320((class_2338)mutableBlockPos).method_26216((class_1922)levelAccessor, (class_2338)mutableBlockPos)) continue;
                    class_2680 blockstate = featureConfiguration.field_21230.method_23455(random, pos);
                    if (blockstate.method_28498((class_2769)class_2381.field_11167) && blockstate.method_28498((class_2769)class_2381.field_11172) && blockstate.method_28498((class_2769)class_2381.field_11171) && blockstate.method_28498((class_2769)class_2381.field_11170) && blockstate.method_28498((class_2769)class_2381.field_11166)) {
                        blockstate = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)blockstate.method_11657((class_2769)class_2381.field_11166, (Comparable)Boolean.valueOf(y >= height - 1))).method_11657((class_2769)class_2381.field_11167, (Comparable)Boolean.valueOf(x < -k))).method_11657((class_2769)class_2381.field_11172, (Comparable)Boolean.valueOf(x > k))).method_11657((class_2769)class_2381.field_11171, (Comparable)Boolean.valueOf(z < -k))).method_11657((class_2769)class_2381.field_11170, (Comparable)Boolean.valueOf(z > k));
                    }
                    this.method_13153((class_1945)levelAccessor, (class_2338)mutableBlockPos, blockstate);
                }
            }
        }
    }

    protected void makeSmoothCap(class_1936 levelAccessor, Random random, class_2338 pos, int height, class_2338.class_2339 mutableBlockPos, class_4635 featureConfiguration) {
        for (int y = height - 2; y <= height + 1; ++y) {
            int j = featureConfiguration.field_21232 - Math.max(0, y - (height - 1)) + 1;
            for (int x = -j; x <= j; ++x) {
                for (int z = -j; z <= j; ++z) {
                    if (!TFGenCanopyMushroomRed.isInsideSmoothShape(height, j, x, y, z)) continue;
                    mutableBlockPos.method_25504((class_2382)pos, x, y, z);
                    if (levelAccessor.method_8320((class_2338)mutableBlockPos).method_26216((class_1922)levelAccessor, (class_2338)mutableBlockPos)) continue;
                    class_2680 blockstate = featureConfiguration.field_21230.method_23455(random, pos);
                    if (blockstate.method_28498((class_2769)class_2381.field_11167) && blockstate.method_28498((class_2769)class_2381.field_11172) && blockstate.method_28498((class_2769)class_2381.field_11171) && blockstate.method_28498((class_2769)class_2381.field_11170) && blockstate.method_28498((class_2769)class_2381.field_11166)) {
                        blockstate = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)blockstate.method_11657((class_2769)class_2381.field_11166, (Comparable)Boolean.valueOf(!TFGenCanopyMushroomRed.isInsideSmoothShape(height, j - (y > height - 2 ? 1 : 0), x, y + 1, z)))).method_11657((class_2769)class_2381.field_11167, (Comparable)Boolean.valueOf(!TFGenCanopyMushroomRed.isInsideSmoothShape(height, j, x - 1, y, z) && x < 0))).method_11657((class_2769)class_2381.field_11172, (Comparable)Boolean.valueOf(!TFGenCanopyMushroomRed.isInsideSmoothShape(height, j, x + 1, y, z) && x > 0))).method_11657((class_2769)class_2381.field_11171, (Comparable)Boolean.valueOf(!TFGenCanopyMushroomRed.isInsideSmoothShape(height, j, x, y, z - 1) && z < 0))).method_11657((class_2769)class_2381.field_11170, (Comparable)Boolean.valueOf(!TFGenCanopyMushroomRed.isInsideSmoothShape(height, j, x, y, z + 1) && z > 0));
                    }
                    this.method_13153((class_1945)levelAccessor, (class_2338)mutableBlockPos, blockstate);
                }
            }
        }
    }

    private static boolean isInsideSmoothShape(int height, int j, int x, int y, int z) {
        boolean zMinMax;
        int i = y - (height - 2);
        if (i == 4 || Math.abs(x) > j || Math.abs(z) > j) {
            return false;
        }
        if (i >= 2) {
            return true;
        }
        boolean xIsMin = x == -j;
        boolean xIsMax = x == j;
        boolean zIsMin = z == -j;
        boolean zIsMax = z == j;
        boolean xMinMax = xIsMin || xIsMax;
        boolean bl = zMinMax = zIsMin || zIsMax;
        if (i == 1 && (xMinMax && Math.abs(z) == j - 1 || zMinMax && Math.abs(x) == j - 1)) {
            return false;
        }
        return xMinMax != zMinMax || Math.abs(x) == Math.abs(z) && Math.abs(x) == j - 1;
    }

    protected void makeSpheroidCap(class_1936 levelAccessor, Random random, class_2338 pos, int height, class_2338.class_2339 mutableBlockPos, class_4635 featureConfiguration) {
        for (int y = height - 2; y <= height; ++y) {
            int j = y == height - 1 ? featureConfiguration.field_21232 + 2 : featureConfiguration.field_21232 + 1;
            for (int x = -j; x <= j; ++x) {
                for (int z = -j; z <= j; ++z) {
                    double maxDistance;
                    double distance = Math.sqrt(x * x + z * z);
                    if (!(distance <= (maxDistance = (double)j + 0.1))) continue;
                    mutableBlockPos.method_25504((class_2382)pos, x, y, z);
                    if (levelAccessor.method_8320((class_2338)mutableBlockPos).method_26216((class_1922)levelAccessor, (class_2338)mutableBlockPos)) continue;
                    class_2680 blockstate = featureConfiguration.field_21230.method_23455(random, pos);
                    if (blockstate.method_28498((class_2769)class_2381.field_11167) && blockstate.method_28498((class_2769)class_2381.field_11172) && blockstate.method_28498((class_2769)class_2381.field_11171) && blockstate.method_28498((class_2769)class_2381.field_11170) && blockstate.method_28498((class_2769)class_2381.field_11166)) {
                        blockstate = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)blockstate.method_11657((class_2769)class_2381.field_11166, (Comparable)Boolean.valueOf(y > height - 2 && (y == height || distance > maxDistance - 1.0)))).method_11657((class_2769)class_2381.field_11167, (Comparable)Boolean.valueOf(Math.sqrt((x - 1) * (x - 1) + z * z) > maxDistance))).method_11657((class_2769)class_2381.field_11172, (Comparable)Boolean.valueOf(Math.sqrt((x + 1) * (x + 1) + z * z) > maxDistance))).method_11657((class_2769)class_2381.field_11171, (Comparable)Boolean.valueOf(Math.sqrt(x * x + (z - 1) * (z - 1)) > maxDistance))).method_11657((class_2769)class_2381.field_11170, (Comparable)Boolean.valueOf(Math.sqrt(x * x + (z + 1) * (z + 1)) > maxDistance));
                    }
                    this.method_13153((class_1945)levelAccessor, (class_2338)mutableBlockPos, blockstate);
                }
            }
        }
    }
}

